/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.reflect;

import com.andavin.reflect.AttributeMatcher;
import com.andavin.reflect.Reflection;
import com.andavin.reflect.exception.UncheckedNoSuchMethodException;
import com.andavin.reflect.exception.UncheckedReflectiveOperationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ConstructorMatcher
extends AttributeMatcher<Constructor, ConstructorMatcher> {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class<?>[] parametersTypes;

    public ConstructorMatcher() {
        this(EMPTY_CLASS_ARRAY);
    }

    public ConstructorMatcher(Class<?> ... parametersTypes) {
        super(null, Modifier.constructorModifiers());
        this.parametersTypes = parametersTypes;
    }

    @Override
    public ConstructorMatcher requireExactMatch() {
        this.requireExactMatch = true;
        return this;
    }

    @Override
    public boolean match(Constructor constructor) {
        return this.match(constructor.getModifiers(), null) && (this.parametersTypes == null || Reflection.compare(constructor.getParameterTypes(), this.parametersTypes, this.requireExactMatch));
    }

    @Override
    UncheckedReflectiveOperationException buildException() {
        return new UncheckedNoSuchMethodException("Could not find Constructor(" + (this.parametersTypes != null ? Arrays.stream(this.parametersTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) : "any parameters") + ") requiring " + Integer.toBinaryString(this.requiredModifiers) + " and disallowing " + Integer.toBinaryString(this.disallowedModifiers));
    }
}

